/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2020 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2020 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS (Twitter:@kugimoto0715)
 *
 *	[ ⏕c[ ]
 */

#ifndef _tools_h_
#define _tools_h_

/*
 *	萔`
 */
#define TYPE_NOSUPPORT	0			/* ΏۊO */
#define TYPE_2D			1			/* fBXNC[W2D */
#define TYPE_2DD		2			/* fBXNC[W2DD */
#define TYPE_2HD		3			/* fBXNC[W2HD(gp) */
#define TYPE_B32		4			/* ouC[W32KB */
#define TYPE_B128		5			/* ouC[W128KB(gp) */

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
BOOL FASTCALL make_new_d77(char *fname, char *name, BOOL mediatype);
										/* uNfBXN쐬 */
BOOL FASTCALL make_new_userdisk(char *fname, char *name, BOOL mediatype);
										/* [UfBXN쐬 */
BOOL FASTCALL make_new_t77(char *fname);
										/* uNe[v쐬 */
#if XM7_VER == 1 && defined(BUBBLE)
BOOL FASTCALL make_new_bubble(char *fname, char *name);
										/* uNouJZbg쐬 */
#endif
BOOL FASTCALL conv_vfd_to_d77(char *src, char *dst, char *name);
										/* VFDD77ϊ */
BOOL FASTCALL conv_2d_to_d77(char *src, char *dst, char *name);
										/* 2D/2DDD77ϊ */
BOOL FASTCALL conv_vtp_to_t77(char *src, char *dst);
										/* VTPT77ϊ */
BOOL FASTCALL capture_to_bmp(char *fname, BOOL fullscan, MONITORTYPE monitortype, BOOL p400line);
										/* ʃLv`(BMP) */
BOOL FASTCALL capture_to_bmp2(char *fname, MONITORTYPE monitortype, BOOL p400line);
										/* ʃLv`(BMPEk摜) */
DWORD FASTCALL get_file_size(char *fname);
										/* t@CTCY擾 */
BOOL FASTCALL set_title_media(char *fname, int index, char *name);
										/* fBA^CgύX */
BOOL FASTCALL get_title_media(char *fname, int index, char *name);
										/* fBA^Cg擾 */
int FASTCALL get_media_num(char *fname);
										/* fBA擾 */
int FASTCALL check_disk(char *fname, int index);
										/* fBXNt@C`FbN */
#if XM7_VER == 1 && defined(BUBBLE)
BOOL FASTCALL conv_bbl_to_b77(char *src, char *dst, char *name);
										/* BBLB77ϊ */
int FASTCALL check_bubble(char *fname, int index);
										/* out@C`FbN */
#endif

/*
 *	FDXT|[g
 */
BOOL FASTCALL make_new_fdx(char *fname, char *name, BOOL mediatype);
										/* uNfBXN쐬(FDX) */
BOOL FASTCALL make_new_userdisk_fdx(char *fname, char *name, BOOL mediatype);
										/* [UfBXN쐬(FDX) */

#ifdef __cplusplus
}
#endif

#endif	/* _tools_h_ */
